/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.crafting.fluiditem;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.RegistryObject;
import novamachina.exnihilosequentia.common.crafting.ExNihiloRecipeSerializer;
import novamachina.exnihilosequentia.common.crafting.SerializableRecipe;

public class FluidItemRecipe
extends SerializableRecipe {
    public static RecipeType<FluidItemRecipe> RECIPE_TYPE;
    @Nullable
    private static RegistryObject<ExNihiloRecipeSerializer<FluidItemRecipe>> serializer;
    @Nonnull
    private FluidStack fluid;
    @Nonnull
    private Ingredient input;
    @Nonnull
    private ItemStack output;

    public FluidItemRecipe(@Nonnull ResourceLocation id, @Nonnull FluidStack fluid, @Nonnull Ingredient input, @Nonnull ItemStack output) {
        super(output, RECIPE_TYPE, id);
        this.fluid = fluid;
        this.input = input;
        this.output = output;
    }

    @Nullable
    public static RegistryObject<ExNihiloRecipeSerializer<FluidItemRecipe>> getStaticSerializer() {
        return serializer;
    }

    public static void setSerializer(@Nonnull RegistryObject<ExNihiloRecipeSerializer<FluidItemRecipe>> serializer) {
        FluidItemRecipe.serializer = serializer;
    }

    @Nonnull
    public FluidStack getFluidInBarrel() {
        return this.fluid;
    }

    @Nonnull
    public Ingredient getInput() {
        return this.input;
    }

    public void setInput(@Nonnull Ingredient input) {
        this.input = input;
    }

    @Nonnull
    public List<ItemStack> getInputs() {
        return Arrays.asList(this.input.m_43908_());
    }

    @Nonnull
    public ItemStack m_8043_() {
        return this.output;
    }

    public void setFluid(@Nonnull FluidStack fluidInBarrel) {
        this.fluid = fluidInBarrel;
    }

    public void setOutput(@Nonnull ItemStack output) {
        this.output = output;
    }

    public boolean validInputs(@Nonnull Fluid fluid, @Nonnull Item input) {
        return this.fluid.getFluid().m_6212_(fluid) && this.input.test(new ItemStack((ItemLike)input));
    }

    @Nullable
    protected ExNihiloRecipeSerializer<FluidItemRecipe> getENSerializer() {
        if (serializer == null) {
            return null;
        }
        return (ExNihiloRecipeSerializer)((Object)serializer.get());
    }
}

